/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch;

import com.aptana.portal.ui.dispatch.ActionControllerProxy;
import com.aptana.portal.ui.dispatch.IActionController;
import com.aptana.portal.ui.dispatch.browserNotifications.AbstractBrowserNotification;
import com.aptana.portal.ui.dispatch.browserNotifications.BrowserNotificationProxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BrowserInteractionRegistry {
    private static final String EXTENSION_POINT_ID = "com.aptana.portal.ui.browserInteractions";
    private static final String TAG_CONTROLLER = "actionController";
    private static final String TAG_NOTIFICATION = "browserNotification";
    private static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    private static BrowserInteractionRegistry instance = null;
    private Map<String, IActionController> controllers = new HashMap<String, IActionController>();
    private Map<String, AbstractBrowserNotification> notifiers = new HashMap<String, AbstractBrowserNotification>();

    private BrowserInteractionRegistry() {
        this.readExtensionRegistry();
    }

    public static BrowserInteractionRegistry getInstance() {
        if (instance == null) {
            instance = new BrowserInteractionRegistry();
        }
        return instance;
    }

    public IActionController[] getActionControllers() {
        return this.controllers.values().toArray(new IActionController[this.controllers.size()]);
    }

    public IActionController getActionController(String id) {
        return this.controllers.get(id);
    }

    public boolean hasActionController(String id) {
        return this.getActionController(id) != null;
    }

    public String[] getActionControllersIDs() {
        return this.controllers.keySet().toArray(new String[this.controllers.size()]);
    }

    public AbstractBrowserNotification[] getBrowserNotifications() {
        return this.notifiers.values().toArray(new AbstractBrowserNotification[this.notifiers.size()]);
    }

    public String[] getBrowserNotificationsIDs() {
        return this.notifiers.keySet().toArray(new String[this.notifiers.size()]);
    }

    public AbstractBrowserNotification getBrowserNotification(String id) {
        return this.notifiers.get(id);
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element) {
        boolean isControllerElement = TAG_CONTROLLER.equals(element.getName());
        boolean isNotificationElement = TAG_NOTIFICATION.equals(element.getName());
        if (isControllerElement || isNotificationElement) {
            String id = element.getAttribute(ATT_ID);
            if (id == null || id.length() == 0) {
                return;
            }
            String clazz = element.getAttribute(ATT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            if (isControllerElement) {
                ActionControllerProxy actionController = new ActionControllerProxy(element);
                this.controllers.put(id, actionController);
            } else {
                BrowserNotificationProxy notification = new BrowserNotificationProxy(element);
                this.notifiers.put(id, notification);
            }
        }
    }
}

